/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import common.Assert;
import java.util.ArrayList;
import xlrd.Sheet;
import xlrd.Workbook;
import xlrd.biff.BOFRecord;
import xlrd.biff.BiffException;
import xlrd.biff.BoundsheetRecord;
import xlrd.biff.File;
import xlrd.biff.FormatRecord;
import xlrd.biff.FormattingRecords;
import xlrd.biff.NameRecord;
import xlrd.biff.Record;
import xlrd.biff.SSTRecord;
import xlrd.biff.SheetImpl;
import xlrd.biff.Type;
import xlrd.biff.XFRecord;

public class WorkbookParser
extends Workbook {
    private File excelFile;
    private int bofs;
    private SSTRecord sharedStrings;
    private ArrayList boundsheets;
    private FormattingRecords formattingRecords;
    private ArrayList sheets;
    private SheetImpl lastSheet;

    public WorkbookParser(File f) {
        this.excelFile = f;
        this.boundsheets = new ArrayList(10);
        this.formattingRecords = new FormattingRecords();
        this.sheets = new ArrayList(10);
    }

    public Sheet[] getSheets() {
        Sheet[] sheetArray = new Sheet[this.getNumberOfSheets()];
        for (int i = 0; i < this.getNumberOfSheets(); ++i) {
            sheetArray[i] = (Sheet)this.sheets.get(i);
        }
        return sheetArray;
    }

    public Sheet getSheet(int index) {
        if (this.lastSheet != null) {
            this.lastSheet.clear();
            System.gc();
        }
        this.lastSheet = (SheetImpl)this.sheets.get(index);
        this.lastSheet.readSheet();
        return this.lastSheet;
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public void close() {
        this.lastSheet.clear();
        this.excelFile.clear();
        System.gc();
    }

    final void addSheet(Sheet s) {
        this.sheets.add(s);
    }

    protected void parse() throws BiffException {
        Record r = null;
        BOFRecord bof = new BOFRecord(this.excelFile.next());
        ++this.bofs;
        if (!bof.isBiff8() && !bof.isBiff7()) {
            throw new BiffException(BiffException.unrecognizedBiffVersion);
        }
        if (!bof.isWorkbookGlobals()) {
            throw new BiffException(BiffException.expectedGlobals);
        }
        ArrayList<Record> continueRecords = new ArrayList<Record>();
        while (this.bofs == 1) {
            Object nextrec;
            r = this.excelFile.next();
            if (r.getType() == Type.SST) {
                continueRecords.clear();
                nextrec = this.excelFile.peek();
                while (((Record)nextrec).getType() == Type.CONTINUE) {
                    continueRecords.add(this.excelFile.next());
                    nextrec = this.excelFile.peek();
                }
                Object[] rec = continueRecords.toArray();
                Record[] records = new Record[rec.length];
                System.arraycopy(rec, 0, records, 0, rec.length);
                this.sharedStrings = new SSTRecord(r, records);
            }
            if (r.getType() == Type.TXO) {
                // empty if block
            }
            if (r.getType() == Type.NAME) {
                nextrec = new NameRecord(r);
            }
            if (r.getType() == Type.ROW) {
                // empty if block
            }
            if (r.getType() == Type.FORMAT) {
                FormatRecord fr = null;
                fr = bof.isBiff8() ? new FormatRecord(r, FormatRecord.biff8) : new FormatRecord(r, FormatRecord.biff7);
                this.formattingRecords.add(fr);
            }
            if (r.getType() == Type.XF) {
                XFRecord xfr = new XFRecord(r);
                this.formattingRecords.add(xfr);
            }
            if (r.getType() == Type.BOUNDSHEET) {
                BoundsheetRecord br = null;
                br = bof.isBiff8() ? new BoundsheetRecord(r) : new BoundsheetRecord(r, BoundsheetRecord.biff7);
                this.boundsheets.add(br);
            }
            if (r.getType() == Type.EXTSST) {
                // empty if block
            }
            if (r.getType() == Type.CONTINUE) {
                // empty if block
            }
            if (r.getType() != Type.EOF) continue;
            --this.bofs;
        }
        r = this.excelFile.next();
        Assert.assert(r.getType() == Type.BOF);
        bof = new BOFRecord(r);
        while (bof != null && bof.isWorksheet()) {
            if (!bof.isBiff8() && !bof.isBiff7()) {
                throw new BiffException(BiffException.unrecognizedBiffVersion);
            }
            SheetImpl s = new SheetImpl(this.excelFile, this.sharedStrings, this.formattingRecords, bof);
            BoundsheetRecord br = (BoundsheetRecord)this.boundsheets.get(this.getNumberOfSheets());
            s.setName(br.getName());
            this.addSheet(s);
            bof = null;
            if (!this.excelFile.hasNext() || (r = this.excelFile.next()).getType() != Type.BOF) continue;
            bof = new BOFRecord(r);
        }
    }
}

