/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import common.Assert;
import xlrd.Cell;
import xlrd.CellType;
import xlrd.LabelCell;
import xlrd.Sheet;
import xlrd.biff.BOFRecord;
import xlrd.biff.BiffException;
import xlrd.biff.BooleanRecord;
import xlrd.biff.DateRecord;
import xlrd.biff.DimensionRecord;
import xlrd.biff.EmptyCell;
import xlrd.biff.ErrorRecord;
import xlrd.biff.File;
import xlrd.biff.FormattingRecords;
import xlrd.biff.FormulaRecord;
import xlrd.biff.LabelRecord;
import xlrd.biff.LabelSSTRecord;
import xlrd.biff.MulRKRecord;
import xlrd.biff.NumberFormulaRecord;
import xlrd.biff.NumberRecord;
import xlrd.biff.NumberValue;
import xlrd.biff.RKHelper;
import xlrd.biff.RKRecord;
import xlrd.biff.Record;
import xlrd.biff.RecordData;
import xlrd.biff.SSTRecord;
import xlrd.biff.Type;

class SheetImpl
implements Sheet {
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord bofRecord;
    private FormattingRecords formattingRecords;
    private String name;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private int startPosition;

    SheetImpl(File f, SSTRecord sst, FormattingRecords fr, BOFRecord br) throws BiffException {
        this.excelFile = f;
        this.sharedStrings = sst;
        this.formattingRecords = fr;
        this.bofRecord = br;
        this.startPosition = f.getPos();
        Record r = null;
        int bofs = 1;
        while (bofs >= 1) {
            r = f.next();
            if (r.getCode() == Type.EOF.value) {
                --bofs;
            }
            if (r.getCode() != Type.BOF.value) continue;
            ++bofs;
        }
    }

    public Cell getCell(int row, int column) {
        Cell c;
        if (this.cells == null) {
            this.readSheet();
        }
        if ((c = this.cells[row][column]) == null) {
            c = new EmptyCell(row, column);
            this.addCell(c);
        }
        return c;
    }

    public int getRows() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numRows;
    }

    public int getColumns() {
        if (this.cells == null) {
            this.readSheet();
        }
        return this.numCols;
    }

    public Cell[] getRow(int row) {
        if (this.cells == null) {
            this.readSheet();
        }
        Cell[] cells = new Cell[this.numCols];
        for (int i = 0; i < this.numCols; ++i) {
            cells[i] = this.getCell(row, i);
        }
        return cells;
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        for (int i = 0; i < this.getRows() && !found; ++i) {
            Cell[] row = this.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (!row[j].getContents().equals(contents)) continue;
                cell = row[j];
                found = true;
            }
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        for (int i = 0; i < this.getRows() && !found; ++i) {
            Cell[] row = this.getRow(i);
            for (int j = 0; j < row.length && !found; ++j) {
                if (row[j].getType() != CellType.LABEL && row[j].getType() != CellType.STRING_FORMULA || !row[j].getContents().equals(contents)) continue;
                cell = (LabelCell)row[j];
                found = true;
            }
        }
        return cell;
    }

    public Cell[] getColumn(int col) {
        if (this.cells == null) {
            this.readSheet();
        }
        Cell[] cells = new Cell[this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            cells[i] = this.getCell(i, col);
        }
        return cells;
    }

    public String getName() {
        return this.name;
    }

    void setName(String s) {
        this.name = s;
    }

    void clear() {
        this.cells = null;
        System.gc();
    }

    private void addCell(Cell cell) {
        Assert.assert(this.cells[cell.getRow()][cell.getColumn()] == null);
        this.cells[cell.getRow()][cell.getColumn()] = cell;
    }

    void readSheet() {
        Record r = null;
        boolean cont = true;
        this.excelFile.setPos(this.startPosition);
        while (cont) {
            RecordData br;
            DateRecord dc;
            r = this.excelFile.next();
            if (r.getType() == Type.DIMENSION) {
                DimensionRecord dr = null;
                dr = this.bofRecord.isBiff8() ? new DimensionRecord(r) : new DimensionRecord(r, DimensionRecord.biff7);
                this.numRows = dr.getNumberOfRows();
                this.numCols = dr.getNumberOfColumns();
                this.cells = new Cell[this.numRows][this.numCols];
            }
            if (r.getType() == Type.LABELSST) {
                LabelSSTRecord label = new LabelSSTRecord(r, this.sharedStrings);
                this.addCell(label);
            }
            if (r.getType() == Type.RK || r.getType() == Type.RK2) {
                RKRecord rkr = new RKRecord(r, this.formattingRecords);
                if (this.formattingRecords.isDate(rkr.getXFIndex())) {
                    dc = new DateRecord(rkr, this.formattingRecords.getDateFormat(rkr.getXFIndex()));
                    this.addCell(dc);
                } else {
                    this.addCell(rkr);
                }
            }
            if (r.getType() == Type.MULRK) {
                MulRKRecord mulrk = new MulRKRecord(r);
                int num = mulrk.getNumberOfColumns();
                int ixf = 0;
                for (int i = 0; i < num; ++i) {
                    NumberValue nv = new NumberValue(mulrk.getRow(), mulrk.getFirstColumn() + i, RKHelper.getDouble(mulrk.getRKNumber(i)));
                    ixf = mulrk.getXFIndex(i);
                    if (this.formattingRecords.isDate(ixf)) {
                        DateRecord dc2 = new DateRecord(nv, this.formattingRecords.getDateFormat(ixf));
                        this.addCell(dc2);
                        continue;
                    }
                    nv.setNumberFormat(this.formattingRecords.getNumberFormat(ixf));
                    this.addCell(nv);
                }
            }
            if (r.getType() == Type.ROW) {
                // empty if block
            }
            if (r.getType() == Type.NUMBER) {
                NumberRecord nr = new NumberRecord(r, this.formattingRecords);
                if (this.formattingRecords.isDate(nr.getXFIndex())) {
                    dc = new DateRecord(nr, this.formattingRecords.getDateFormat(nr.getXFIndex()));
                    this.addCell(dc);
                } else {
                    this.addCell(nr);
                }
            }
            if (r.getType() == Type.BOOLERR) {
                br = new BooleanRecord(r);
                if (((BooleanRecord)br).isError()) {
                    ErrorRecord er = new ErrorRecord(br.getRecord());
                    this.addCell(er);
                } else {
                    this.addCell((Cell)((Object)br));
                }
            }
            if (r.getType() == Type.CONTINUE) {
                // empty if block
            }
            if (r.getType() == Type.NOTE) {
                // empty if block
            }
            if (r.getType() == Type.FORMULA || r.getType() == Type.FORMULA2) {
                NumberFormulaRecord nfr;
                FormulaRecord fr = new FormulaRecord(r, this.excelFile);
                Cell cell = fr.getFormula();
                if (fr.getFormula().getType() == CellType.NUMBER_FORMULA && this.formattingRecords.isDate((nfr = (NumberFormulaRecord)fr.getFormula()).getXFIndex())) {
                    cell = new DateRecord(nfr, this.formattingRecords.getDateFormat(nfr.getXFIndex()));
                }
                this.addCell(cell);
            }
            if (r.getType() == Type.LABEL) {
                LabelRecord lr = new LabelRecord(r);
                this.addCell(lr);
            }
            if (r.getType() == Type.NAME) {
                // empty if block
            }
            if (r.getType() == Type.BOF) {
                br = new BOFRecord(r);
                Assert.assert(!((BOFRecord)br).isWorksheet());
                Record r2 = this.excelFile.next();
                while (r2.getCode() != Type.EOF.value) {
                    r2 = this.excelFile.next();
                }
            }
            if (r.getType() != Type.EOF) continue;
            cont = false;
        }
        this.excelFile.restorePos();
    }
}

