/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import xlrd.CellType;
import xlrd.NumberCell;
import xlrd.biff.CellValue;
import xlrd.biff.FormattingRecords;
import xlrd.biff.IntegerHelper;
import xlrd.biff.Record;

class NumberRecord
extends CellValue
implements NumberCell {
    private double value;
    private int xfIndex;
    private NumberFormat format;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    public NumberRecord(Record t, FormattingRecords fr) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.xfIndex = IntegerHelper.getInt(data[4], data[5]);
        int num1 = IntegerHelper.getInt(data[6], data[7], data[8], data[9]);
        int num2 = IntegerHelper.getInt(data[10], data[11], data[12], data[13]);
        String s1 = Integer.toBinaryString(num1);
        while (s1.length() < 32) {
            s1 = String.valueOf("0").concat(String.valueOf(s1));
        }
        boolean negative = (num2 & Integer.MIN_VALUE) != 0;
        String s = String.valueOf(Integer.toBinaryString(num2 & Integer.MAX_VALUE)).concat(String.valueOf(s1));
        long val = Long.parseLong(s, 2);
        this.value = Double.longBitsToDouble(val);
        if (negative) {
            this.value = -this.value;
        }
        this.format = fr.getNumberFormat(this.xfIndex);
        if (this.format == null) {
            this.format = defaultFormat;
        }
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return this.format.format(this.value);
    }

    public CellType getType() {
        return CellType.NUMBER;
    }

    public int getXFIndex() {
        return this.xfIndex;
    }
}

