/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import java.text.DecimalFormat;
import xlrd.CellType;
import xlrd.NumberCell;
import xlrd.biff.CellValue;
import xlrd.biff.IntegerHelper;
import xlrd.biff.Record;

class NumberFormulaRecord
extends CellValue
implements NumberCell {
    private int xfIndex;
    private double value;
    private static DecimalFormat format = new DecimalFormat("#.###");

    public NumberFormulaRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.xfIndex = IntegerHelper.getInt(data[4], data[5]);
        long num1 = IntegerHelper.getInt(data[6], data[7], data[8], data[9]);
        long num2 = IntegerHelper.getInt(data[10], data[11], data[12], data[13]);
        long val = (num2 << 32) + num1;
        this.value = Double.longBitsToDouble(val);
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return format.format(this.value);
    }

    public int getXFIndex() {
        return this.xfIndex;
    }

    public CellType getType() {
        return CellType.NUMBER_FORMULA;
    }
}

