/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import xlrd.biff.IntegerHelper;
import xlrd.biff.Record;
import xlrd.biff.RecordData;

class FormatRecord
extends RecordData {
    private int indexCode;
    private String formatString;
    private boolean date;
    private boolean number;
    private Format format;
    private static String[] dateStrings = new String[]{"dd", "mm", "yy", "hh", "ss", "m/", "/d"};
    public static final BiffType biff8 = new BiffType();
    public static final BiffType biff7 = new BiffType();

    public FormatRecord(Record t, BiffType biffType) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.indexCode = IntegerHelper.getInt(data[0], data[1]);
        byte numchars = data[2];
        byte[] chars = new byte[numchars];
        if (biffType == biff8) {
            System.arraycopy(data, 5, chars, 0, chars.length);
        } else {
            System.arraycopy(data, 3, chars, 0, chars.length);
        }
        this.formatString = new String(chars);
        this.date = false;
        this.number = false;
        for (int i = 0; i < dateStrings.length; ++i) {
            if (this.formatString.indexOf(dateStrings[i]) == -1) continue;
            this.date = true;
        }
        if (!(this.date || this.formatString.indexOf(35) == -1 && this.formatString.indexOf(48) == -1)) {
            this.number = true;
        }
    }

    public boolean isDate() {
        return this.date;
    }

    public boolean isNumber() {
        return this.number;
    }

    public NumberFormat getNumberFormat() {
        if (this.format != null && this.format instanceof NumberFormat) {
            return (NumberFormat)this.format;
        }
        try {
            String fs = this.formatString;
            fs = this.replace(fs, "E+", "E");
            fs = this.replace(fs, "_)", "");
            fs = this.replace(fs, "[Red]", "");
            fs = this.replace(fs, "\\", "");
            this.format = new DecimalFormat(fs);
        }
        catch (IllegalArgumentException e) {
            this.format = new DecimalFormat("#.###");
        }
        return (NumberFormat)this.format;
    }

    private String replace(String input, String search, String replace) {
        String formatString = input;
        int pos = formatString.indexOf(search);
        while (pos != -1) {
            StringBuffer tmp = new StringBuffer(formatString.substring(0, pos));
            tmp.append(replace);
            tmp.append(formatString.substring(pos + search.length()));
            formatString = tmp.toString();
            pos = formatString.indexOf(search);
        }
        return formatString;
    }

    public DateFormat getDateFormat() {
        StringBuffer sb;
        if (this.format != null && this.format instanceof DateFormat) {
            return (DateFormat)this.format;
        }
        String fmt = this.formatString;
        int pos = fmt.indexOf("AM/PM");
        while (pos != -1) {
            sb = new StringBuffer(fmt.substring(0, pos));
            sb.append('a');
            sb.append(fmt.substring(pos + 5));
            fmt = sb.toString();
            pos = fmt.indexOf("AM/PM");
        }
        pos = fmt.indexOf("ss.0");
        while (pos != -1) {
            sb = new StringBuffer(fmt.substring(0, pos));
            sb.append("ss.SSS");
            pos += 4;
            while (pos < fmt.length() && fmt.charAt(pos) == '0') {
                ++pos;
            }
            sb.append(fmt.substring(pos));
            fmt = sb.toString();
            pos = fmt.indexOf("ss.0");
        }
        sb = new StringBuffer();
        for (int i = 0; i < fmt.length(); ++i) {
            if (fmt.charAt(i) == '\\') continue;
            sb.append(fmt.charAt(i));
        }
        fmt = sb.toString();
        char[] format = fmt.toCharArray();
        for (int i = 0; i < format.length; ++i) {
            char ind;
            int j;
            int j2;
            if (format[i] != 'm') continue;
            if (i > 0 && (format[i - 1] == 'm' || format[i - 1] == 'M')) {
                format[i] = format[i - 1];
                continue;
            }
            int minuteDist = Integer.MAX_VALUE;
            for (j2 = i - 1; j2 > 0; --j2) {
                if (format[j2] != 'h') continue;
                minuteDist = i - j2;
                break;
            }
            for (j2 = i + 1; j2 < format.length; ++j2) {
                if (format[j2] != 'h') continue;
                minuteDist = Math.min(minuteDist, j2 - i);
                break;
            }
            for (j2 = i - 1; j2 > 0; --j2) {
                if (format[j2] != 's') continue;
                minuteDist = Math.min(minuteDist, i - j2);
                break;
            }
            for (j2 = i + 1; j2 < format.length; ++j2) {
                if (format[j2] != 's') continue;
                minuteDist = Math.min(minuteDist, j2 - i);
                break;
            }
            int monthDist = Integer.MAX_VALUE;
            for (j = i - 1; j > 0; --j) {
                if (format[j] != 'd') continue;
                monthDist = i - j;
                break;
            }
            for (j = i + 1; j < format.length; ++j) {
                if (format[j] != 'd') continue;
                monthDist = Math.min(monthDist, j - i);
                break;
            }
            for (j = i - 1; j > 0; --j) {
                if (format[j] != 'y') continue;
                monthDist = Math.min(monthDist, i - j);
                break;
            }
            for (j = i + 1; j < format.length; ++j) {
                if (format[j] != 'y') continue;
                monthDist = Math.min(monthDist, j - i);
                break;
            }
            if (monthDist < minuteDist) {
                format[i] = Character.toUpperCase(format[i]);
                continue;
            }
            if (monthDist != minuteDist || monthDist == Integer.MAX_VALUE || (ind = format[i - monthDist]) != 'y' && ind != 'd') continue;
            format[i] = Character.toUpperCase(format[i]);
        }
        try {
            this.format = new SimpleDateFormat(new String(format));
        }
        catch (IllegalArgumentException e) {
            this.format = new SimpleDateFormat("dd MM yyyy hh:mm:ss");
        }
        return (DateFormat)this.format;
    }

    public int getIndexCode() {
        return this.indexCode;
    }

    private static class BiffType {
        private BiffType() {
        }
    }
}

