/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import common.Assert;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import xlrd.CellType;
import xlrd.DateCell;
import xlrd.NumberCell;

class DateRecord
implements DateCell {
    private Date date;
    private int row;
    private int column;
    private boolean time;
    private DateFormat format;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd MMM yyyy");
    private static final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final TimeZone gmtZone = TimeZone.getTimeZone("GMT");
    private static final int utcOffsetDays = 25569;
    private static final long msInADay = 86400000L;

    public DateRecord(NumberCell num, DateFormat df) {
        this.row = num.getRow();
        this.column = num.getColumn();
        this.format = df;
        double numValue = num.getValue();
        if (Math.abs(numValue) < 1.0) {
            if (this.format == null) {
                this.format = timeFormat;
            }
            this.time = true;
        } else {
            if (this.format == null) {
                this.format = dateFormat;
            }
            this.time = false;
        }
        this.format.setTimeZone(gmtZone);
        double utcDays = numValue - (double)25569;
        long utcValue = Math.round(utcDays * (double)86400000L);
        this.date = new Date(utcValue);
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public Date getDate() {
        return this.date;
    }

    public String getContents() {
        return this.format.format(this.date);
    }

    public CellType getType() {
        return CellType.DATE;
    }

    public boolean isTime() {
        return this.time;
    }

    public DateFormat getDateFormat() {
        Assert.assert(this.format != null);
        return this.format;
    }
}

