/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import xlrd.biff.IntegerHelper;
import xlrd.biff.Record;
import xlrd.biff.RecordData;

class BoundsheetRecord
extends RecordData {
    private int offset;
    private byte typeFlag;
    private byte visibilityFlag;
    private int length;
    private String name;
    public static Biff7 biff7 = new Biff7();

    public BoundsheetRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.offset = IntegerHelper.getInt(data[0], data[1], data[2], data[3]);
        this.typeFlag = data[4];
        this.visibilityFlag = data[5];
        this.length = IntegerHelper.getInt(data[6], data[7]);
        byte[] bytes = new byte[this.length];
        System.arraycopy(data, 8, bytes, 0, this.length);
        this.name = new String(bytes);
    }

    public BoundsheetRecord(Record t, Biff7 biff7) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.offset = IntegerHelper.getInt(data[0], data[1], data[2], data[3]);
        this.typeFlag = data[4];
        this.visibilityFlag = data[5];
        this.length = data[6];
        byte[] bytes = new byte[this.length];
        System.arraycopy(data, 7, bytes, 0, this.length);
        this.name = new String(bytes);
    }

    public String getName() {
        return this.name;
    }

    private static class Biff7 {
        private Biff7() {
        }
    }
}

