/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import common.Assert;
import xlrd.BooleanCell;
import xlrd.CellType;
import xlrd.biff.CellValue;
import xlrd.biff.Record;

class BooleanRecord
extends CellValue
implements BooleanCell {
    private boolean error = false;
    private boolean value = false;

    public BooleanRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        boolean bl = this.error = data[7] == 1;
        if (!this.error) {
            this.value = data[6] == 1;
        }
    }

    public boolean isError() {
        return this.error;
    }

    public boolean getValue() {
        return this.value;
    }

    public String getContents() {
        Assert.assert(!this.isError());
        return new Boolean(this.value).toString();
    }

    public CellType getType() {
        return CellType.BOOLEAN;
    }
}

