/*
 * Decompiled with CFR 0.152.
 */
package xlrd.biff;

import xlrd.biff.IntegerHelper;
import xlrd.biff.Record;
import xlrd.biff.RecordData;

class BOFRecord
extends RecordData {
    private static final int Biff8 = 1536;
    private static final int Biff7 = 1280;
    private static final int WorkbookGlobals = 5;
    private static final int Worksheet = 16;
    private int version;
    private int substreamType;

    public BOFRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.version = IntegerHelper.getInt(data[0], data[1]);
        this.substreamType = IntegerHelper.getInt(data[2], data[3]);
    }

    public boolean isBiff8() {
        return this.version == 1536;
    }

    public boolean isBiff7() {
        return this.version == 1280;
    }

    public boolean isWorkbookGlobals() {
        return this.substreamType == 5;
    }

    public boolean isWorksheet() {
        return this.substreamType == 16;
    }
}

