/*
 * Decompiled with CFR 0.152.
 */
package xlrd;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import xlrd.Cell;
import xlrd.CellType;
import xlrd.Sheet;
import xlrd.Workbook;

public class XML {
    public XML(Workbook w, OutputStream out, String encoding) throws IOException {
        if (encoding == null || !encoding.equals("UnicodeBig")) {
            encoding = "UTF8";
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter(out, encoding);
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write("<?xml version=\"1.0\" ?>");
            bw.newLine();
            bw.write("<!DOCTYPE workbook SYSTEM \"workbook.dtd\">");
            bw.newLine();
            bw.newLine();
            bw.write("<workbook>");
            bw.newLine();
            for (int sheet = 0; sheet < w.getNumberOfSheets(); ++sheet) {
                Sheet s = w.getSheet(sheet);
                bw.write("  <sheet>");
                bw.newLine();
                bw.write(String.valueOf(String.valueOf("    <name><![CDATA[").concat(String.valueOf(s.getName()))).concat(String.valueOf("]]></name>")));
                bw.newLine();
                Cell[] row = null;
                for (int i = 0; i < s.getRows(); ++i) {
                    bw.write(String.valueOf(String.valueOf("    <row number=\"").concat(String.valueOf(i))).concat(String.valueOf("\">")));
                    bw.newLine();
                    row = s.getRow(i);
                    boolean nonblank = false;
                    for (int j = 0; j < row.length; ++j) {
                        if (row[j].getType() == CellType.EMPTY) continue;
                        bw.write(String.valueOf(String.valueOf("      <col number=\"").concat(String.valueOf(j))).concat(String.valueOf("\">")));
                        bw.write(String.valueOf(String.valueOf("<![CDATA[").concat(String.valueOf(row[j].getContents()))).concat(String.valueOf("]]>")));
                        bw.write("</col>");
                        bw.newLine();
                    }
                    bw.write("    </row>");
                    bw.newLine();
                }
                bw.write("  </sheet>");
                bw.newLine();
            }
            bw.write("</workbook>");
            bw.newLine();
            bw.flush();
            bw.close();
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.toString());
        }
    }
}

