/*
 * Decompiled with CFR 0.152.
 */
package xlrd;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import packages.utilities.FileHandler;
import packages.utilities.utilities;
import xlrd.Cell;
import xlrd.CellType;
import xlrd.Sheet;
import xlrd.Workbook;

public class CSV {
    private FileHandler fileHandler = new FileHandler();
    private String LOG_FILE_DIR = ".\\";
    private String LOG_CSV_FILE_NAME = "xl.xls";

    public CSV(Workbook w, OutputStream out, String encoding) throws IOException {
        if (encoding == null || !encoding.equals("UnicodeBig")) {
            encoding = "UTF8";
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter(out, encoding);
            BufferedWriter bw = new BufferedWriter(osw);
            for (int sheet = 0; sheet < w.getNumberOfSheets(); ++sheet) {
                Sheet s = w.getSheet(sheet);
                bw.write(s.getName());
                bw.newLine();
                Cell[] row = null;
                for (int i = 0; i < s.getRows(); ++i) {
                    row = s.getRow(i);
                    int nonblank = 0;
                    for (int j = row.length - 1; j >= 0; --j) {
                        if (row[j].getType() == CellType.EMPTY) continue;
                        nonblank = j;
                        break;
                    }
                    String sRow = row[0].getContents().toString();
                    bw.write(row[0].getContents());
                    for (int j = 1; j <= nonblank; ++j) {
                        bw.write(44);
                        bw.write(row[j].getContents());
                    }
                    bw.newLine();
                }
            }
            bw.flush();
            bw.close();
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.toString());
        }
    }

    public CSV(Workbook w, Vector vect, String encoding) throws IOException {
        if (encoding == null || !encoding.equals("UnicodeBig")) {
            encoding = "UTF8";
        }
        try {
            for (int sheet = 0; sheet < w.getNumberOfSheets(); ++sheet) {
                Sheet s = w.getSheet(sheet);
                vect.addElement(s.getName());
                Cell[] row = null;
                for (int i = 0; i < s.getRows(); ++i) {
                    StringBuffer sThisRow = new StringBuffer("");
                    row = s.getRow(i);
                    int nonblank = 0;
                    for (int j = row.length - 1; j >= 0; --j) {
                        if (row[j].getType() == CellType.EMPTY) continue;
                        nonblank = j;
                        break;
                    }
                    String sRow = row[0].getContents().toString();
                    sThisRow.append(row[0].getContents());
                    for (int j = 1; j <= nonblank; ++j) {
                        sThisRow.append('~');
                        sThisRow.append(row[j].getContents());
                    }
                    vect.addElement(sThisRow.toString());
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }

    private void log(String sMsg) {
        try {
            System.out.println(sMsg);
            for (int i = 0; i < 30; ++i) {
                this.fileHandler.appendToFile(this.LOG_FILE_DIR, this.LOG_CSV_FILE_NAME, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(sMsg).concat(String.valueOf(""))).concat(String.valueOf(i))).concat(String.valueOf(1))).concat(String.valueOf("\t"))).concat(String.valueOf(sMsg))).concat(String.valueOf(i))).concat(String.valueOf(2))).concat(String.valueOf("\t"))).concat(String.valueOf(sMsg))).concat(String.valueOf(i))).concat(String.valueOf(3))).concat(String.valueOf("\t"))).concat(String.valueOf(sMsg))).concat(String.valueOf(i))).concat(String.valueOf(4))).concat(String.valueOf("\t"))).concat(String.valueOf(sMsg))).concat(String.valueOf(i))).concat(String.valueOf(5))).concat(String.valueOf("\t"))).concat(String.valueOf(sMsg)));
            }
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(String.valueOf(String.valueOf("ERROR 001: CSV: error printing ").concat(String.valueOf(sMsg))).concat(String.valueOf(".."))).concat(String.valueOf(ex)));
        }
    }

    public static Vector addAllLines(Vector vect) {
        Vector returnVect = new Vector();
        utilities util = new utilities();
        Enumeration enumeration = vect.elements();
        while (enumeration.hasMoreElements()) {
            String thisLine = (String)enumeration.nextElement();
            StringTokenizer st = new StringTokenizer(thisLine, "~");
            StringBuffer sb = new StringBuffer();
            int token = 0;
            double doubleTotalThisLine = 0.0;
            String thisPart = "";
            String thisPen = "";
            boolean validLine = false;
            boolean invalidPen = false;
            while (st.hasMoreTokens()) {
                String thisToken = st.nextToken();
                if (token == 0) {
                    thisPart = thisToken;
                } else if (token == 1) {
                    if (util.IsNumeric(thisToken, true)) {
                        invalidPen = true;
                    }
                    thisPen = thisToken;
                } else if (!invalidPen && util.IsNumeric(thisToken.trim(), true)) {
                    validLine = true;
                    doubleTotalThisLine += util.getLastDouble();
                }
                ++token;
            }
            if (!validLine) continue;
            Vector<Object> thisLineVect = new Vector<Object>();
            thisLineVect.addElement(thisPart);
            thisLineVect.addElement(thisPen);
            thisLineVect.addElement(new Double(doubleTotalThisLine));
            returnVect.addElement(thisLineVect);
        }
        return returnVect;
    }
}

