/*
 * Decompiled with CFR 0.152.
 */
package packages.utilities;

import java.awt.Dimension;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class utilities {
    private Vector labelsAndControlsVector;
    private double lastDouble = 0.0;

    public utilities() {
    }

    public utilities(Vector labelsAndControlsVector) {
        this.labelsAndControlsVector = labelsAndControlsVector;
    }

    public void addComponentsToVector(JLabel label, JComponent comp, JLabel blankLabel) {
        this.labelsAndControlsVector.addElement(label);
        this.labelsAndControlsVector.addElement(comp);
        if (blankLabel != null) {
            utilities.changeBoth(blankLabel);
        }
        utilities.changeBoth(label);
        utilities.changeBoth(comp);
    }

    public static void changeBoth(JComponent comp) {
        comp.setAlignmentX(0.5f);
        comp.setAlignmentY(0.5f);
        Dimension dim = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        comp.setMaximumSize(dim);
    }

    public static void changeWidth(JComponent comp) {
        comp.setAlignmentX(0.5f);
        comp.setAlignmentY(0.5f);
        Dimension dim = comp.getPreferredSize();
        dim.width = Integer.MAX_VALUE;
        comp.setMaximumSize(dim);
    }

    public String[] ExtractStringsFromLongString(String longString, String delimitingToken) {
        String[] subStr = null;
        try {
            try {
                StringTokenizer st = new StringTokenizer(longString, delimitingToken);
                int index = 0;
                subStr = new String[st.countTokens()];
                while (st.hasMoreTokens()) {
                    String ss = st.nextToken();
                    subStr[index++] = ss;
                }
                Object var9_9 = null;
                return subStr;
            }
            catch (NullPointerException st) {
                Object var9_10 = null;
                return subStr;
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 094: utilities: ExtractStringsFromLongString: ").concat(String.valueOf(ex.toString())));
                Object var9_11 = null;
                return subStr;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            return subStr;
        }
    }

    public String[] getStringsFromVector(Vector List2) {
        int numElements = List2.size();
        String[] StringList = new String[numElements];
        try {
            Enumeration enumeration = List2.elements();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                String thisOne;
                StringList[i] = thisOne = (String)enumeration.nextElement();
                ++i;
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 095: utilities: getStringsFromVector: ").concat(String.valueOf(ex)));
        }
        return StringList;
    }

    public int getArrayIndex(String[] sArray, String searchVal) {
        int arrayIndex = -1;
        boolean found = false;
        try {
            try {
                for (int i = 0; i < sArray.length && !found; ++i) {
                    if (!sArray[i].equals(searchVal)) continue;
                    found = true;
                    arrayIndex = i;
                }
                Object var7_7 = null;
                return arrayIndex;
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 096: utilities: getArrayIndex: ").concat(String.valueOf(ex)));
                Object var7_8 = null;
                return arrayIndex;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            return arrayIndex;
        }
    }

    public String[] getStringArrFromDBIVector(Vector dbiVector, int dataColumn) {
        String[] dataFromCol = new String[]{};
        try {
            try {
                Vector ThisRow = new Vector();
                Enumeration enumeration = dbiVector.elements();
                int numRows = dbiVector.size();
                dataFromCol = new String[numRows];
                int i = 0;
                while (enumeration.hasMoreElements()) {
                    String thisRowsData;
                    ThisRow = (Vector)enumeration.nextElement();
                    dataFromCol[i] = thisRowsData = (String)ThisRow.elementAt(dataColumn);
                    ++i;
                }
                Object var10_10 = null;
                return dataFromCol;
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 097: utilities: getStringArrFromDBIVector: ").concat(String.valueOf(ex.toString())));
                Object var10_11 = null;
                return dataFromCol;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            return dataFromCol;
        }
    }

    public boolean IsLettersAndDigits(String str) {
        boolean OK = true;
        try {
            try {
                for (int j = 0; j < str.length() && OK; ++j) {
                    char ch = str.charAt(j);
                    if (Character.isLetterOrDigit(ch)) continue;
                    OK = false;
                }
                Object var6_6 = null;
                return OK;
            }
            catch (Exception e) {
                ProdMaint.logMessageToFile(String.valueOf(String.valueOf(String.valueOf("ERROR 098: utilities: IsLettersAndDigits: ").concat(String.valueOf(e.toString()))).concat(String.valueOf(", str="))).concat(String.valueOf(str)));
                OK = false;
                Object var6_7 = null;
                return OK;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            return OK;
        }
    }

    public boolean IsNumeric(String str) {
        boolean OK = true;
        try {
            try {
                for (int j = 0; j < str.length() && OK; ++j) {
                    char ch = str.charAt(j);
                    if (Character.isDigit(ch) || ch == '.') continue;
                    OK = false;
                }
                Object var6_6 = null;
                return OK;
            }
            catch (NumberFormatException e) {
                OK = false;
                Object var6_7 = null;
                return OK;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            return OK;
        }
    }

    public boolean IsNumeric(String str, boolean containsCommas) {
        boolean OK = true;
        try {
            block7: {
                try {
                    String stringWithoutCommas = "";
                    if (containsCommas) {
                        StringTokenizer st = new StringTokenizer(str, ",");
                        StringBuffer sb = new StringBuffer();
                        boolean token = false;
                        while (st.hasMoreTokens()) {
                            stringWithoutCommas = String.valueOf(stringWithoutCommas).concat(String.valueOf(st.nextToken()));
                        }
                        str = stringWithoutCommas;
                    }
                    for (int j = 0; j < str.length() && OK; ++j) {
                        char ch = str.charAt(j);
                        if (Character.isDigit(ch) || ch == '.') continue;
                        OK = false;
                    }
                    if (!OK || !containsCommas) break block7;
                    this.lastDouble = Double.parseDouble(stringWithoutCommas);
                }
                catch (NumberFormatException e) {
                    OK = false;
                    Object var9_12 = null;
                    return OK;
                }
            }
            Object var9_11 = null;
            return OK;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            return OK;
        }
    }

    public double getLastDouble() {
        return this.lastDouble;
    }

    public String makeSpaces(int numSpaces) {
        String spaces = "";
        for (int i = 0; i < numSpaces; ++i) {
            spaces = String.valueOf(spaces).concat(String.valueOf(" "));
        }
        return spaces;
    }

    public String makeString(int num, String sChar) {
        String string = "";
        for (int i = 0; i < num; ++i) {
            string = String.valueOf(string).concat(String.valueOf(sChar));
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String padString(String str, int desiredLength, char padChar) {
        String newString = str;
        String strippedString = "";
        try {
            try {
                for (int i = 0; i < str.length(); ++i) {
                    if (str.charAt(i) == '\r' || str.charAt(i) == '\n') continue;
                    strippedString = String.valueOf(strippedString).concat(String.valueOf(str.substring(i, i + 1)));
                }
                newString = str = strippedString;
                int strLen = str.length();
                if (strLen >= desiredLength) {
                    String string = newString = str;
                    return newString;
                }
                String padCharString = String.valueOf(padChar);
                int numPadChars = desiredLength - strLen;
                for (int i = 0; i < numPadChars; ++i) {
                    newString = String.valueOf(newString).concat(String.valueOf(padCharString));
                }
                return newString;
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 099: utilities: padString: ").concat(String.valueOf(ex)));
                return newString;
            }
        }
        catch (Throwable throwable) {
            return newString;
        }
    }

    public String searchVector(Vector vect, int searchCol, int dataCol, String searchVal) {
        boolean found = false;
        String sFoundVal = "";
        try {
            try {
                Enumeration enumeration = vect.elements();
                while (enumeration.hasMoreElements() && !found) {
                    Vector thisRow = (Vector)enumeration.nextElement();
                    String thisSearchVal = thisRow.elementAt(searchCol).toString();
                    String thisDataVal = thisRow.elementAt(dataCol).toString();
                    if (!thisSearchVal.equals(searchVal)) continue;
                    found = true;
                    sFoundVal = thisDataVal;
                }
                Object var12_12 = null;
                return sFoundVal;
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 100: utilities: searchVector: ").concat(String.valueOf(ex)));
                Object var12_13 = null;
                return sFoundVal;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            return sFoundVal;
        }
    }

    public Vector searchVector(Vector vect, int searchCol, String searchVal) {
        Vector<Vector> retVect = new Vector<Vector>();
        String sFoundVal = "";
        try {
            try {
                Enumeration enumeration = vect.elements();
                while (enumeration.hasMoreElements()) {
                    Vector thisRow = (Vector)enumeration.nextElement();
                    String thisSearchVal = thisRow.elementAt(searchCol).toString();
                    if (!thisSearchVal.equals(searchVal)) continue;
                    retVect.addElement(thisRow);
                }
                Object var10_10 = null;
                return retVect;
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 101: utilities: searchVector: ").concat(String.valueOf(ex)));
                Object var10_11 = null;
                return retVect;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            return retVect;
        }
    }

    public String[] addStringArrays(String[] arr1, String[] arr2, boolean leadingSpace) {
        String[] retVal = null;
        try {
            try {
                int i;
                int len = arr1.length + arr2.length;
                if (leadingSpace) {
                    ++len;
                }
                retVal = new String[len];
                int offset = 0;
                if (leadingSpace) {
                    offset = 1;
                    retVal[0] = "";
                }
                for (i = 0; i < arr1.length; ++i) {
                    retVal[i + offset] = arr1[i];
                }
                for (i = arr1.length; i < len; ++i) {
                    retVal[i + offset] = arr2[i - arr1.length];
                }
                Object var9_9 = null;
                return retVal;
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 102: utilities: addStringArrays: ").concat(String.valueOf(ex)));
                Object var9_10 = null;
                return retVal;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            return retVal;
        }
    }

    public boolean searchStringArr(String[] sArr, String sValue) {
        boolean found = false;
        try {
            try {
                for (int i = 0; i < sArr.length && !found; ++i) {
                    if (!sArr[i].equals(sValue)) continue;
                    found = true;
                }
                Object var6_6 = null;
                return found;
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 103: utilities: searchStringArr: ").concat(String.valueOf(ex)));
                Object var6_7 = null;
                return found;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            return found;
        }
    }

    public void setLF() {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (UnsupportedLookAndFeelException exc) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 104: utilities: setLF(): Warning: Unsupported Look And Feel: ").concat(String.valueOf(laf)));
        }
        catch (Exception exc) {
            ProdMaint.logMessageToFile(String.valueOf(String.valueOf(String.valueOf("ERROR 105: utilities: setLF(): Error loading ").concat(String.valueOf(laf))).concat(String.valueOf(": "))).concat(String.valueOf(exc)));
        }
    }

    public void setLF(JFrame frame) {
        String laf = UIManager.getSystemLookAndFeelClassName();
        try {
            UIManager.setLookAndFeel(laf);
            SwingUtilities.updateComponentTreeUI(frame);
        }
        catch (UnsupportedLookAndFeelException exc) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 106: utilities: setLF(JFrame): Warning: Unsupported Look And Feel: ").concat(String.valueOf(laf)));
        }
        catch (Exception exc) {
            ProdMaint.logMessageToFile(String.valueOf(String.valueOf(String.valueOf("ERROR 107: utilities: setLF(JFrame): Error loading ").concat(String.valueOf(laf))).concat(String.valueOf(": "))).concat(String.valueOf(exc)));
        }
    }

    public Vector sortList(Vector unsortedList) {
        Vector List2 = unsortedList;
        try {
            try {
                int count = List2.size();
                boolean unsorted = false;
                do {
                    unsorted = false;
                    for (int i = 0; i < count - 1; ++i) {
                        String thisValue = "";
                        String nextValue = "";
                        thisValue = (String)List2.elementAt(i);
                        if (thisValue.compareTo(nextValue = (String)List2.elementAt(i + 1)) <= 0) continue;
                        String spare = (String)List2.elementAt(i);
                        List2.setElementAt(List2.elementAt(i + 1), i);
                        List2.setElementAt(spare, i + 1);
                        unsorted = true;
                    }
                } while (unsorted);
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 108: utilities: searchVector: ").concat(String.valueOf(ex)));
                Object var10_11 = null;
                return List2;
            }
            Object var10_10 = null;
            return List2;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            return List2;
        }
    }

    public String StripDirectoryName(String longFileName) {
        String sFile = "";
        try {
            try {
                int endOfPath = longFileName.lastIndexOf("\\");
                sFile = longFileName.substring(endOfPath + 1);
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf(String.valueOf(String.valueOf("ERROR 109: utilities: StripDirectoryName: ").concat(String.valueOf(ex))).concat(String.valueOf(", longFileName is "))).concat(String.valueOf(longFileName)));
                Object var5_6 = null;
                return sFile;
            }
            Object var5_5 = null;
            return sFile;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            return sFile;
        }
    }

    public void tweak(Vector thecomponents) {
        try {
            Dimension dim;
            JComponent component;
            int maxWidth = 0;
            Enumeration enumeration = thecomponents.elements();
            while (enumeration.hasMoreElements()) {
                component = (JComponent)enumeration.nextElement();
                dim = component.getPreferredSize();
                if (dim.width <= maxWidth) continue;
                maxWidth = dim.width;
            }
            enumeration = thecomponents.elements();
            while (enumeration.hasMoreElements()) {
                component = (JComponent)enumeration.nextElement();
                dim = component.getPreferredSize();
                dim.width = maxWidth;
                component.setPreferredSize(dim);
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 110: utilities: searchVector: ").concat(String.valueOf(ex)));
        }
    }

    public String stripCommas(String str) {
        try {
            try {
                String stringWithoutCommas = "";
                StringTokenizer st = new StringTokenizer(str, ",");
                StringBuffer sb = new StringBuffer();
                boolean token = false;
                while (st.hasMoreTokens()) {
                    stringWithoutCommas = String.valueOf(stringWithoutCommas).concat(String.valueOf(st.nextToken()));
                }
                str = stringWithoutCommas.trim();
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 111: utilities: stripCommas: ").concat(String.valueOf(ex)));
                Object var7_8 = null;
                return str;
            }
            Object var7_7 = null;
            return str;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            return str;
        }
    }

    public String toPlacesOfDecimals(String orig, int numPlaces) {
        try {
            block4: {
                try {
                    int indexOfDecimal = orig.indexOf(".");
                    if (indexOfDecimal == 0 || indexOfDecimal + numPlaces + 1 >= orig.length()) break block4;
                    orig = orig.substring(0, indexOfDecimal + numPlaces + 1);
                }
                catch (Exception exc) {
                    ProdMaint.logMessageToFile(String.valueOf("ERROR 112: utilities: toPlacesOfDecimals: ").concat(String.valueOf(exc)));
                    Object var5_6 = null;
                    return orig;
                }
            }
            Object var5_5 = null;
            return orig;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            return orig;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String prependString(String str, int desiredLength, String padChar) {
        try {
            try {
                str = str.trim();
                String frontBit = "";
                int strLen = str.length();
                if (strLen >= desiredLength) {
                    String string = str;
                    return str;
                }
                int numPadChars = desiredLength - strLen;
                int i = 0;
                while (i < numPadChars) {
                    frontBit = String.valueOf(frontBit).concat(String.valueOf(padChar));
                    ++i;
                }
                return String.valueOf(frontBit).concat(String.valueOf(str));
            }
            catch (Exception ex) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 113: utilities: prependString : ").concat(String.valueOf(ex)));
                return str;
            }
        }
        catch (Throwable throwable) {
            return str;
        }
    }

    public String[][] MakeNameValuePairFromTildaString(Vector List2) {
        int numElements = List2.size();
        String[][] StringList = new String[numElements][2];
        try {
            Enumeration enumeration = List2.elements();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                String thisOne = (String)enumeration.nextElement();
                String[] thisRow = this.ExtractStringsFromLongString(thisOne, "~");
                String[] parsedRow = new String[2];
                double thisValuesTotal = 0.0;
                if (thisRow.length > 1) {
                    String s;
                    parsedRow[0] = thisRow[0];
                    for (int j = 1; j < thisRow.length; ++j) {
                        if (!this.IsNumeric(thisRow[j], true)) continue;
                        thisValuesTotal += this.lastDouble;
                    }
                    parsedRow[1] = s = new Double(thisValuesTotal).toString();
                }
                StringList[i] = parsedRow;
                ++i;
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 114: utilities: MakeNameValuePairFromTildaString: ").concat(String.valueOf(ex)));
        }
        return StringList;
    }

    public String makeTildaString(String[] strAr) {
        String line = "";
        for (int i = 0; i < strAr.length; ++i) {
            if (strAr[i] == null) continue;
            line = String.valueOf(line).concat(String.valueOf(String.valueOf(strAr[i]).concat(String.valueOf("~"))));
        }
        return line;
    }
}

