/*
 * Decompiled with CFR 0.152.
 */
package packages.utilities;

public class MonetaryDisplay {
    public static final char EXP = 'E';
    public static final char DECIMAL = '.';
    public static final char COMMA = ',';
    public static final char MINUS = '-';
    public static final char SPACE = ' ';

    private MonetaryDisplay() {
    }

    public static String setPaymentFormat(double d) {
        return MonetaryDisplay.setPaymentFormat(String.valueOf("").concat(String.valueOf(d)));
    }

    public static String setPaymentFormat(Double d) {
        return MonetaryDisplay.setPaymentFormat(d.toString());
    }

    public static String setPaymentFormat(String str) {
        return MonetaryDisplay.setAmountFormat(str);
    }

    public static Object setPaymentFormat(Object o) {
        return MonetaryDisplay.setAmountFormat(o.toString());
    }

    public static String setBalanceFormat(double d) {
        return MonetaryDisplay.setBalanceFormat(String.valueOf("").concat(String.valueOf(d)));
    }

    public static String setBalanceFormat(Double d) {
        return MonetaryDisplay.setBalanceFormat(d.toString());
    }

    public static String setBalanceFormat(String s) {
        return MonetaryDisplay.setAmountFormat(s, true);
    }

    public static String setBalanceFormatNoDecimal(Double s) {
        return MonetaryDisplay.setAmountFormatNoDecimal(s.toString(), true);
    }

    public static Object setBalanceFormat(Object o) {
        return MonetaryDisplay.setBalanceFormat(o.toString());
    }

    public static String setAmountFormat(String str) {
        return MonetaryDisplay.setAmountFormat(str, false);
    }

    public static String setAmountFormat(Double d) {
        return MonetaryDisplay.setAmountFormat(d.toString(), false);
    }

    public static Object setAmountFormat(Object o) {
        return MonetaryDisplay.setAmountFormat(o.toString());
    }

    public static String setAmountFormatNoDecimal(String amount, boolean indicator) {
        String kept = new String(amount);
        try {
            amount = MonetaryDisplay.rebuild(amount);
            amount = MonetaryDisplay.doCommas(amount);
            int loc = amount.lastIndexOf(".");
            amount = amount.substring(0, loc);
            if (indicator) {
                amount = MonetaryDisplay.doDebitCreditIndicator(amount);
            }
            String string = amount;
            return string;
        }
        catch (Exception e) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 037: MonetaryDisplay: setAmountFormatNoDecimal ").concat(String.valueOf(kept)));
            String string = "NA";
            return string;
        }
    }

    public static String setAmountFormat(String amount, boolean indicator) {
        return MonetaryDisplay.setAmountFormat(amount, indicator, true);
    }

    public static String setAmountFormat(String amount, boolean indicator, boolean commas) {
        String kept = new String(amount);
        try {
            amount = MonetaryDisplay.rebuild(amount);
            amount = MonetaryDisplay.addDecimal(amount);
            if (commas) {
                amount = MonetaryDisplay.doCommas(amount);
            }
            if (indicator) {
                amount = MonetaryDisplay.doDebitCreditIndicator(amount);
            }
            String string = amount;
            return string;
        }
        catch (Exception e) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 038: MonetaryDisplay: setAmountFormat: couldn't parse: ").concat(String.valueOf(kept)));
            String string = "NA";
            return string;
        }
    }

    public static String setInterestFormat(Double d) {
        return MonetaryDisplay.setInterestFormat(d.toString());
    }

    public static String setInterestFormat(String str) {
        String kept = new String(str);
        try {
            String string = MonetaryDisplay.rebuild(str);
            return string;
        }
        catch (Exception e) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 039: MonetaryDisplay:  setInterestFormat: couldn't parse: ").concat(String.valueOf(kept)));
            String string = "NA";
            return string;
        }
    }

    public static String rebuild(String str) {
        if (!MonetaryDisplay.isExponential(str)) {
            return str;
        }
        String before_E = str.substring(0, str.indexOf(69));
        String after_E = str.substring(str.indexOf(69) + 1, str.length());
        int reqDecimalPlaces = new Integer(after_E);
        String before_D = before_E.substring(0, before_E.indexOf(46));
        String after_D = before_E.substring(before_E.indexOf(46) + 1, before_E.length());
        int actDecimalPlaces = after_D.length();
        int actDigits = before_D.length();
        String amount = String.valueOf(before_D).concat(String.valueOf(after_D));
        if (reqDecimalPlaces >= 0) {
            if (reqDecimalPlaces > actDecimalPlaces) {
                int count = reqDecimalPlaces - actDecimalPlaces;
                for (int i = 0; i < count; ++i) {
                    amount = String.valueOf(amount).concat(String.valueOf("0"));
                }
            } else {
                int position = before_D.length() + reqDecimalPlaces;
                String before = amount.substring(0, position);
                String after = amount.substring(position);
                amount = String.valueOf(String.valueOf(before).concat(String.valueOf('.'))).concat(String.valueOf(after));
            }
        } else {
            int absDecimalPlaces = Math.abs(reqDecimalPlaces);
            int count = 0;
            if (absDecimalPlaces > actDigits) {
                count = absDecimalPlaces - actDigits;
                for (int i = 0; i < count; ++i) {
                    amount = String.valueOf("0").concat(String.valueOf(amount));
                }
            }
            int position = before_D.length() + count - absDecimalPlaces;
            String before = amount.substring(0, position);
            String after = amount.substring(position);
            amount = before.length() > 0 ? String.valueOf(String.valueOf(before).concat(String.valueOf('.'))).concat(String.valueOf(after)) : String.valueOf("0.").concat(String.valueOf(after));
        }
        return amount;
    }

    public static boolean isExponential(String str) {
        return str.indexOf(69) != -1;
    }

    private static String addDecimal(String str) {
        int decimalPlace = str.indexOf(".");
        if (decimalPlace < 0) {
            str = String.valueOf(str).concat(String.valueOf(".00"));
        } else {
            String tmp = str.substring(decimalPlace + 1, str.length());
            if (tmp.length() != 2) {
                str = tmp.length() == 1 ? String.valueOf(str).concat(String.valueOf("0")) : (tmp.length() == 0 ? String.valueOf(str).concat(String.valueOf("00")) : str.substring(0, decimalPlace + 3));
            }
        }
        return str;
    }

    public static String toPositiveWithoutSpace(String str2) {
        String newString = str2;
        if (str2.length() > 0 && str2.charAt(0) == '-') {
            newString = str2.substring(1);
        }
        return newString;
    }

    public static String toPositive(String str2) {
        String newString = str2;
        if (str2.charAt(0) == '-') {
            newString = String.valueOf(' ').concat(String.valueOf(str2.substring(1)));
        }
        return newString;
    }

    private static String doCommas(String str) {
        StringBuffer sb = new StringBuffer(str);
        for (int m = str.length() - 6; m > 0 && (m != 1 || sb.charAt(0) != '-'); m -= 3) {
            sb.insert(m, ',');
        }
        return sb.toString();
    }

    private static String doDebitCreditIndicator(String str) {
        return str;
    }

    public static void main(String[] args) {
        String num = null;
        num = "-912.51";
        num = MonetaryDisplay.setBalanceFormat(num);
        num = "1.2345E2";
        num = MonetaryDisplay.setBalanceFormat(num);
        num = "1.2345E8";
        num = MonetaryDisplay.setBalanceFormat(num);
        num = "-1.2345678E7";
        num = MonetaryDisplay.setBalanceFormat(num);
        num = "-1.2345E8";
        num = MonetaryDisplay.setBalanceFormat(num);
        num = "1.2345E1";
        num = MonetaryDisplay.setBalanceFormat(num);
    }

    public static String removeDecimals(String str) {
        if (str.compareTo("NA") != 0) {
            String tmp;
            int len = str.length();
            str = tmp = str.substring(0, len - 3);
        }
        return str;
    }
}

