/*
 * Decompiled with CFR 0.152.
 */
package packages.file;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class FileHandler {
    private String latestError = "";

    public String getLatestError() {
        return this.latestError;
    }

    public File[] getFilesListFromADirectory(String directory) {
        File[] dirList = null;
        try {
            File theDirectory = new File(directory);
            dirList = theDirectory.listFiles();
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("FileHandler.getFilesListFromADirectory error: ").concat(String.valueOf(ex)));
        }
        return dirList;
    }

    public void moveFiles(String directoryFrom, String directoryTo) {
        try {
            File[] dirList = this.getFilesListFromADirectory(directoryFrom);
            for (int i = 0; i < dirList.length; ++i) {
                File thisFile = dirList[i];
                thisFile.renameTo(new File(String.valueOf(directoryTo).concat(String.valueOf(thisFile.getName()))));
                File fileToDelete = new File(String.valueOf(directoryFrom).concat(String.valueOf(thisFile.getName())));
                fileToDelete.delete();
            }
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("FileHandler.moveFiles exception: ").concat(String.valueOf(ex)));
        }
    }

    public synchronized boolean appendToFile(String relativeDirectory, String FileName, Vector Lines) {
        this.latestError = "";
        try {
            if (!this.makeDirectory(relativeDirectory)) {
                boolean bl = false;
                return bl;
            }
            File aFile = new File(relativeDirectory, FileName);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(relativeDirectory).concat(String.valueOf(FileName)), true)));
            Enumeration EnumFiles = Lines.elements();
            while (EnumFiles.hasMoreElements()) {
                String thisLine = (String)EnumFiles.nextElement();
                out.println(thisLine);
            }
        }
        catch (Exception e) {
            this.latestError = String.valueOf("FileHandler Non IO exception thrown: ").concat(String.valueOf(e));
            ProdMaint.logMessageToFile(this.latestError);
            boolean bl = false;
            return bl;
        }
        return false;
    }

    public synchronized boolean appendToFile(String relativeDirectory, String FileName, String Line) {
        this.latestError = "";
        try {
            if (!this.makeDirectory(relativeDirectory)) {
                // empty if block
            }
            File aFile = new File(relativeDirectory, FileName);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(relativeDirectory).concat(String.valueOf(FileName)), true)));
            out.println(Line);
            out.close();
        }
        catch (Exception e) {
            this.latestError = String.valueOf("Non IO exception thrown: ").concat(String.valueOf(e));
            ProdMaint.logMessageToFile(this.latestError);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public synchronized boolean zapFile(String relativeDirectory, String FileName) {
        this.latestError = "";
        try {
            if (!this.makeDirectory(relativeDirectory)) {
                // empty if block
            }
            File aFile = new File(relativeDirectory, FileName);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(relativeDirectory).concat(String.valueOf(FileName)), false)));
            out.println("");
            out.close();
        }
        catch (Exception e) {
            this.latestError = String.valueOf("Non IO exception thrown: ").concat(String.valueOf(e));
            ProdMaint.logMessageToFile(this.latestError);
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public boolean makeAndStoreFile(Vector rowData, String[] delimiters, String[] HeaderData, String[] FooterData, String relativeDirectory, Vector FileNames) {
        this.latestError = "";
        try {
            if (!this.makeDirectory(relativeDirectory)) {
                // empty if block
            }
            Enumeration EnumFiles = FileNames.elements();
            while (EnumFiles.hasMoreElements()) {
                String sPackFileNameSent;
                String thisFileName = (String)EnumFiles.nextElement();
                File aFile = new File(relativeDirectory, thisFileName);
                String dirName = relativeDirectory;
                String fileName = thisFileName;
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(dirName).concat(String.valueOf(fileName)), false)));
                int numRecordsThisFile = 0;
                Enumeration enumeration = rowData.elements();
                while (enumeration.hasMoreElements()) {
                    Vector thisRow = (Vector)enumeration.nextElement();
                    sPackFileNameSent = (String)thisRow.elementAt(9);
                    if (!sPackFileNameSent.equals(thisFileName)) continue;
                    ++numRecordsThisFile;
                }
                for (int i = 0; i < HeaderData.length; ++i) {
                    out.println(String.valueOf(HeaderData[i]).concat(String.valueOf(i == 1 ? String.valueOf(numRecordsThisFile) : "")));
                }
                enumeration = rowData.elements();
                while (enumeration.hasMoreElements()) {
                    Vector thisRow = (Vector)enumeration.nextElement();
                    sPackFileNameSent = (String)thisRow.elementAt(9);
                    if (!sPackFileNameSent.equals(thisFileName)) continue;
                    String sPackCode = (String)thisRow.elementAt(0);
                    String sOrderRef = (String)thisRow.elementAt(1);
                    String sSimCardNo = (String)thisRow.elementAt(2);
                    String sMobileNumber = (String)thisRow.elementAt(3);
                    String sImeiNumber = (String)thisRow.elementAt(4);
                    String sDealerZCode = (String)thisRow.elementAt(5);
                    String sDescription = (String)thisRow.elementAt(6);
                    String sDispatchDate = (String)thisRow.elementAt(7);
                    String sOrderType = (String)thisRow.elementAt(8);
                    out.print(sPackCode);
                    out.print(delimiters[0]);
                    out.print(sOrderRef);
                    out.print(delimiters[1]);
                    out.print(sSimCardNo);
                    out.print(delimiters[2]);
                    out.print(sMobileNumber);
                    out.print(delimiters[3]);
                    out.print(sImeiNumber);
                    out.print(delimiters[4]);
                    out.print(sDealerZCode);
                    out.print(delimiters[5]);
                    out.print(sDescription);
                    out.print(delimiters[6]);
                    out.print(sDispatchDate);
                    out.print(delimiters[7]);
                    out.print(sOrderType);
                    out.print(delimiters[8]);
                    out.print(sPackFileNameSent);
                    out.print(delimiters[9]);
                    out.println("");
                }
                for (int i = 0; i < FooterData.length; ++i) {
                    out.println(String.valueOf(FooterData[i]).concat(String.valueOf(i == 0 ? String.valueOf(numRecordsThisFile) : "")));
                }
                out.close();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.latestError = String.valueOf("IO exception thrown: ").concat(String.valueOf(e));
            ProdMaint.logMessageToFile(this.latestError);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.latestError = String.valueOf("Non IO exception thrown: ").concat(String.valueOf(e));
            ProdMaint.logMessageToFile(this.latestError);
            boolean bl = false;
            return bl;
        }
    }

    public boolean makeAndStoreFile(Vector rowData, String[] delimiters, String HeaderData, String FooterData, String relativeDirectory, String FileName) {
        this.latestError = "";
        try {
            if (!this.makeDirectory(relativeDirectory)) {
                boolean bl = false;
                return bl;
            }
            File aFile = new File(relativeDirectory, FileName);
            String dirName = relativeDirectory;
            String fileName = FileName;
            Enumeration enumeration = rowData.elements();
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(dirName).concat(String.valueOf(fileName)), false)));
            out.print(HeaderData);
            while (enumeration.hasMoreElements()) {
                Vector thisRow = (Vector)enumeration.nextElement();
                String sPackCode = (String)thisRow.elementAt(0);
                String sOrderRef = (String)thisRow.elementAt(1);
                String sSimCardNo = (String)thisRow.elementAt(2);
                String sMobileNumber = (String)thisRow.elementAt(3);
                String sImeiNumber = (String)thisRow.elementAt(4);
                String sDealerZCode = (String)thisRow.elementAt(5);
                String sDescription = (String)thisRow.elementAt(6);
                String sDispatchDate = (String)thisRow.elementAt(7);
                String sOrderType = (String)thisRow.elementAt(8);
                String sPackFileNameSent = (String)thisRow.elementAt(9);
                out.print(sPackCode);
                out.print(delimiters[0]);
                out.print(sOrderRef);
                out.print(delimiters[1]);
                out.print(sSimCardNo);
                out.print(delimiters[2]);
                out.print(sMobileNumber);
                out.print(delimiters[3]);
                out.print(sImeiNumber);
                out.print(delimiters[4]);
                out.print(sDealerZCode);
                out.print(delimiters[5]);
                out.print(sDescription);
                out.print(delimiters[6]);
                out.print(sDispatchDate);
                out.print(delimiters[7]);
                out.println("");
                out.print(sOrderType);
                out.print(delimiters[8]);
                out.println("");
                out.print(sPackFileNameSent);
                out.print(delimiters[9]);
                out.println("");
            }
            out.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.latestError = String.valueOf("IO exception thrown: ").concat(String.valueOf(e));
            ProdMaint.logMessageToFile(this.latestError);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.latestError = String.valueOf("Non IO exception thrown: ").concat(String.valueOf(e));
            ProdMaint.logMessageToFile(this.latestError);
            boolean bl = false;
            return bl;
        }
    }

    public boolean makeDirectory(String relativeDirectory) {
        File dir = new File(relativeDirectory);
        if (!dir.exists()) {
            dir.mkdir();
        } else if (!dir.isDirectory()) {
            this.latestError = String.valueOf(relativeDirectory).concat(String.valueOf(" is not a directory"));
            ProdMaint.logMessageToFile(this.latestError);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector readFile(String directory, String fileName) {
        Vector<String> lines = new Vector<String>();
        try {
            File myFile = new File(directory, fileName);
            DataInputStream fileIn = new DataInputStream(new FileInputStream(myFile));
            boolean EOF = false;
            while (!EOF) {
                try {
                    String thisLine = fileIn.readLine();
                    lines.addElement(thisLine);
                    if (thisLine != null) continue;
                    EOF = true;
                }
                catch (EOFException e) {
                    ProdMaint.logMessageToFile(String.valueOf("FileHandler.readFile: EOFException:").concat(String.valueOf(e)));
                    EOF = true;
                    return lines;
                }
                catch (IOException ex) {
                    ProdMaint.logMessageToFile(String.valueOf("FileHandler.readFile: IOException:").concat(String.valueOf(ex)));
                    return lines;
                }
            }
            return lines;
        }
        catch (FileNotFoundException ex) {
            ProdMaint.logMessageToFile(String.valueOf("FileHandler.readFile: , FileNotFoundException: ").concat(String.valueOf(ex)));
            return lines;
        }
        catch (Exception ex) {
            ProdMaint.logMessageToFile(String.valueOf("FileHandler.readFile: Exception: ").concat(String.valueOf(ex)));
        }
        return lines;
    }
}

