/*
 * Decompiled with CFR 0.152.
 */
package packages.components.table;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class JDBCAdapter
extends AbstractTableModel {
    Connection connection;
    Statement statement;
    ResultSet resultSet;
    String[] columnNames = new String[0];
    public Vector rows = new Vector();
    ResultSetMetaData metaData;

    public JDBCAdapter(String url, String driverName, String user, String passwd) {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            this.connection = DriverManager.getConnection("jdbc:odbc:DB_PARTS", "", "");
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException ex) {
            ProdMaint.logMessageToFile("ERROR 026: JDBCAdapter:  JDBCAdapter constructor error - Cannot find the database driver classes.");
            ProdMaint.logMessageToFile(String.valueOf("ERROR 027: JDBCAdapter:  JDBCAdapter constructor error - ").concat(String.valueOf(ex)));
        }
        catch (SQLException ex) {
            ProdMaint.logMessageToFile("ERROR 028: JDBCAdapter:  JDBCAdapter constructor error - Cannot connect to this database.");
            ProdMaint.logMessageToFile(String.valueOf("ERROR 029: JDBCAdapter:  JDBCAdapter constructor error - ").concat(String.valueOf(ex)));
        }
    }

    public JDBCAdapter(Connection connection) {
        try {
            this.connection = connection;
            this.statement = connection.createStatement();
        }
        catch (SQLException ex) {
            ProdMaint.logMessageToFile("ERROR 030: JDBCAdapter:  JDBCAdapter constructor error - Cannot connect to this database.");
            ProdMaint.logMessageToFile(String.valueOf("ERROR 031: JDBCAdapter:  JDBCAdapter constructor error - ").concat(String.valueOf(ex)));
        }
    }

    public void doNonSelect(String sql) {
        if (this.connection == null || this.statement == null) {
            ProdMaint.logMessageToFile("ERROR 032: JDBCAdapter: doNonSelect: there is no database to execute the query.");
            return;
        }
        try {
            this.statement.execute(sql);
        }
        catch (SQLException ex) {
            ProdMaint.logMessageToFile(String.valueOf(String.valueOf(String.valueOf("ERROR 033: JDBCAdapter: doNonSelect - ").concat(String.valueOf(ex))).concat(String.valueOf(", sql="))).concat(String.valueOf(sql)));
        }
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public synchronized void executeQuery(String query) {
        if (this.connection == null || this.statement == null) {
            ProdMaint.logMessageToFile("ERROR 034: JDBCAdapter: executeQuery: there is no database to execute the query.");
            return;
        }
        try {
            this.statement = this.connection.createStatement();
            this.connection.getMetaData();
            this.resultSet = this.statement.executeQuery(query);
            this.metaData = this.resultSet.getMetaData();
            int numberOfColumns = this.metaData.getColumnCount();
            this.columnNames = new String[numberOfColumns];
            for (int column = 0; column < numberOfColumns; ++column) {
                this.columnNames[column] = this.metaData.getColumnLabel(column + 1);
            }
            this.rows = new Vector();
            while (this.resultSet.next()) {
                Vector<Object> newRow = new Vector<Object>();
                for (int i = 1; i <= this.getColumnCount(); ++i) {
                    Object o = this.resultSet.getObject(i);
                    if (o == null) {
                        o = "";
                    }
                    newRow.addElement(o);
                }
                this.rows.addElement(newRow);
            }
            this.fireTableChanged(null);
        }
        catch (SQLException ex) {
            ProdMaint.logMessageToFile(String.valueOf(String.valueOf(String.valueOf("ERROR 035: JDBCAdapter: public void executeQuery: ").concat(String.valueOf(ex))).concat(String.valueOf(":  "))).concat(String.valueOf(query)));
        }
    }

    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.statement.close();
        this.connection.close();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String getColumnName(int column) {
        if (this.columnNames[column] != null) {
            return this.columnNames[column];
        }
        return "";
    }

    public Class getColumnClass(int column) {
        int type;
        try {
            type = this.metaData.getColumnType(column + 1);
        }
        catch (SQLException e) {
            Class<?> clazz = super.getColumnClass(column);
            return clazz;
        }
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return Class.forName("java.lang.String");
            }
            case -7: {
                return Class.forName("java.lang.Boolean");
            }
            case -6: 
            case 4: 
            case 5: {
                return Class.forName("java.lang.Integer");
            }
            case -5: {
                return Class.forName("java.lang.Long");
            }
            case 6: 
            case 8: {
                return Class.forName("java.lang.Double");
            }
            case 91: {
                return Class.forName("java.sql.Date");
            }
        }
        return Class.forName("java.lang.Object");
    }

    public boolean isCellEditable(int row, int column) {
        try {
            boolean bl = this.metaData.isWritable(column + 1);
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int aRow, int aColumn) {
        Vector row = (Vector)this.rows.elementAt(aRow);
        return row.elementAt(aColumn);
    }

    public String dbRepresentation(int column, Object value) {
        int type;
        if (value == null) {
            return "null";
        }
        try {
            type = this.metaData.getColumnType(column + 1);
        }
        catch (SQLException e) {
            String string = value.toString();
            return string;
        }
        switch (type) {
            case 4: 
            case 6: 
            case 8: {
                return value.toString();
            }
            case -7: {
                return (Boolean)value != false ? "1" : "0";
            }
            case 91: {
                return value.toString();
            }
        }
        return String.valueOf(String.valueOf("\"").concat(String.valueOf(value.toString()))).concat(String.valueOf("\""));
    }

    public void setValueAt(Object value, int row, int column) {
        try {
            String tableName = this.metaData.getTableName(column + 1);
            if (tableName == null) {
                ProdMaint.logMessageToFile("ERROR 036: JDBCAdapter: setValueAt: tablename returned null.");
            }
            String columnName = this.getColumnName(column);
            String query = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("update ").concat(String.valueOf(tableName))).concat(String.valueOf(" set "))).concat(String.valueOf(columnName))).concat(String.valueOf(" = "))).concat(String.valueOf(this.dbRepresentation(column, value)))).concat(String.valueOf(" where "));
            for (int col = 0; col < this.getColumnCount(); ++col) {
                String colName = this.getColumnName(col);
                if (colName.equals("")) continue;
                if (col != 0) {
                    query = String.valueOf(query).concat(String.valueOf(" and "));
                }
                query = String.valueOf(String.valueOf(String.valueOf(query).concat(String.valueOf(colName))).concat(String.valueOf(" = "))).concat(String.valueOf(this.dbRepresentation(col, this.getValueAt(row, col))));
            }
            ProdMaint.logMessageToFile(String.valueOf("ERROR 037: JDBCAdapter: setValueAt: not sending update to database").concat(String.valueOf(query)));
        }
        catch (SQLException e) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 038: JDBCAdapter: setValueAt: update failed  ").concat(String.valueOf(e)));
        }
        Vector dataRow = (Vector)this.rows.elementAt(row);
        dataRow.setElementAt(value, column);
    }
}

