/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.TableModel;
import packages.components.table.JDBCAdapter;
import packages.utilities.FileHandler;
import packages.utilities.utilities;

public class ReportBuilder {
    private String FILE_DIR = ".\\files\\rptfiles\\";
    private String FILE_NAME_ItemS = "tempRpt.xls";
    private String FILE_NAME_PEN = "tempRptPen.xls";
    JDBCAdapter databaseModel;
    ProdMaint parentFrame;
    Vector summedLines;
    Vector allItems;
    Vector allPackaging;
    Vector allItemsPackaging;
    utilities UtilityObject;
    private FileHandler fileHandler;
    double totalTonnageThisItem = 0.0;
    String[][] parsedInputData;
    int numDiffMaterials;
    private double[] IrishInpTot;
    private double[] IrishInpReuse;
    private double[] ImportInpTot;
    private double[] ImportInpReuse;
    private double[] Exports;
    private double[][] WasteMgtTot;
    private double[][] IrishOutputROITot;
    private double[][] IrishOutputROIContReuse;
    private double[][] ImportedOutputROITot;
    private double[][] ImportedOutputROIContReuse;

    public ReportBuilder(JDBCAdapter databaseModel, ProdMaint parentFrame, Vector summedLines) {
        this.databaseModel = databaseModel;
        this.parentFrame = parentFrame;
        this.summedLines = summedLines;
        this.fileHandler = new FileHandler();
        this.UtilityObject = new utilities();
    }

    public void doNewReport(String[][] parsedInputData) {
        this.parsedInputData = parsedInputData;
        try {
            Vector reportData = this.getReportData(parsedInputData);
            this.setupStorageVariables();
            this.loopRecordsetAndFillStorageVariables(reportData);
            Vector reportVector = this.writeReportToVector();
            this.writeReport(reportVector);
        }
        catch (Exception exc) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 081: ReportBuilder: doNewReport ").concat(String.valueOf(exc)));
        }
    }

    private Vector getReportData(String[][] parsedInputData) {
        String selectClause = "SELECT * FROM Items, Packag WHERE Items.item_no=Packag.item_no ";
        String whereClause = "";
        Vector c = null;
        int numInWhereClause = 0;
        try {
            try {
                for (int i = 0; i < parsedInputData.length; ++i) {
                    String[] thisItem = parsedInputData[i];
                    if (thisItem == null || thisItem.length <= 0 || thisItem[0] == null) continue;
                    whereClause = numInWhereClause == 0 ? String.valueOf(whereClause).concat(String.valueOf(String.valueOf(" AND Items.Item_no in ('").concat(String.valueOf(thisItem[0])))) : String.valueOf(whereClause).concat(String.valueOf(String.valueOf("' ,'").concat(String.valueOf(thisItem[0]))));
                    ++numInWhereClause;
                }
                if (numInWhereClause > 0) {
                    whereClause = String.valueOf(whereClause).concat(String.valueOf("')"));
                }
                this.databaseModel.executeQuery(String.valueOf(selectClause).concat(String.valueOf(whereClause)));
                c = this.databaseModel.rows;
            }
            catch (Exception exc) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 082: ReportBuilder: getReportData: ").concat(String.valueOf(exc)));
                Object var9_10 = null;
                return c;
            }
            Object var9_9 = null;
            return c;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            return c;
        }
    }

    private void setupStorageVariables() {
        try {
            this.numDiffMaterials = PackagDialog.materialDD.length;
            this.IrishInpTot = new double[this.numDiffMaterials];
            this.IrishInpReuse = new double[this.numDiffMaterials];
            this.ImportInpTot = new double[this.numDiffMaterials];
            this.ImportInpReuse = new double[this.numDiffMaterials];
            this.Exports = new double[this.numDiffMaterials];
            this.WasteMgtTot = new double[6][this.numDiffMaterials];
            this.IrishOutputROITot = new double[6][this.numDiffMaterials];
            this.IrishOutputROIContReuse = new double[3][this.numDiffMaterials];
            this.ImportedOutputROITot = new double[6][this.numDiffMaterials];
            this.ImportedOutputROIContReuse = new double[3][this.numDiffMaterials];
        }
        catch (Exception exc) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 083: ReportBuilder: setupStorageVariables: ").concat(String.valueOf(exc)));
        }
    }

    private void loopRecordsetAndFillStorageVariables(Vector reportData) {
        boolean countryIE = false;
        double quantityOfItem = 0.0;
        double quantityOfItemExported = 0.0;
        String lastItem = "";
        try {
            Enumeration enumeration = reportData.elements();
            while (enumeration.hasMoreElements()) {
                Vector thisRow = (Vector)enumeration.nextElement();
                String Item = (String)thisRow.elementAt(0);
                String inputOutput = (String)thisRow.elementAt(2);
                String Country = ((String)thisRow.elementAt(4)).toUpperCase();
                String fate = (String)thisRow.elementAt(22);
                String weightPerSU = (String)thisRow.elementAt(21);
                String material = (String)thisRow.elementAt(15);
                String inputItem = (String)thisRow.elementAt(26);
                String packagType = (String)thisRow.elementAt(14);
                String exported = (String)thisRow.elementAt(5);
                String packagingdescr = (String)thisRow.elementAt(13);
                ProdMaint.logMessageToAuditFile("");
                ProdMaint.logMessageToAuditFile("AUDIT +++ parsing a database entry +++");
                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT0 The Item: ").concat(String.valueOf(Item)));
                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT1 has packaging: ").concat(String.valueOf(packagingdescr)));
                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT2 Of type: ").concat(String.valueOf(inputOutput)));
                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT3 with weight (kg) per shipping unit: ").concat(String.valueOf(weightPerSU)));
                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT4 of material type: ").concat(String.valueOf(material)));
                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT packaging type: ").concat(String.valueOf(packagType)));
                boolean bl = countryIE = Country.indexOf("IE") == 0;
                if (!lastItem.equals(Item)) {
                    quantityOfItem = this.getQuantityOfItem(Item, inputOutput, false);
                    ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT5 Quantity of Item to/from Irish market: ").concat(String.valueOf(quantityOfItem)));
                    if (exported.equalsIgnoreCase("Yes") || exported.equalsIgnoreCase("Both")) {
                        quantityOfItemExported = this.getQuantityOfItem(Item, inputOutput, true);
                        ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT6 Quantity Of Item Exported: ").concat(String.valueOf(quantityOfItemExported)));
                    }
                }
                double weightOfMaterial = Double.valueOf(weightPerSU) * quantityOfItem / (double)1000;
                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT Displaying Calculation: Weight per Shipping Unit: ").concat(String.valueOf(Double.valueOf(weightPerSU))));
                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT Displaying Calculation: times Quantity of Item:  x ").concat(String.valueOf(quantityOfItem)));
                ProdMaint.logMessageToAuditFile("AUDIT Displaying Calculation: convert to tonnes:  / 1000 ");
                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT Displaying Calculation: equals (weight in tonnes):  = ").concat(String.valueOf(weightOfMaterial)));
                int indexOfMaterial = this.UtilityObject.getArrayIndex(PackagDialog.materialDD, material) - 1;
                if (inputOutput.equalsIgnoreCase("Input")) {
                    if (countryIE) {
                        int n = indexOfMaterial;
                        this.IrishInpTot[n] = this.IrishInpTot[n] + weightOfMaterial;
                        ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT9 Irish-sourced Input Item, Section 1.1: weight (tonnes): ").concat(String.valueOf(weightOfMaterial)));
                        ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT10 Total so far of this material: ").concat(String.valueOf(this.IrishInpTot[indexOfMaterial])));
                        if (fate.equalsIgnoreCase("Reuse")) {
                            ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT11 This item is destined for Reuse, contributing: ").concat(String.valueOf(weightOfMaterial)));
                            int n2 = indexOfMaterial;
                            this.IrishInpReuse[n2] = this.IrishInpReuse[n2] + weightOfMaterial;
                            ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT12 Total reuse so far of this material: ").concat(String.valueOf(this.IrishInpReuse[indexOfMaterial])));
                        }
                    } else {
                        int n = indexOfMaterial;
                        this.ImportInpTot[n] = this.ImportInpTot[n] + weightOfMaterial;
                        ProdMaint.logMessageToAuditFile("AUDIT13 This is an Imported Input Item");
                        ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT14 contributing weight (t): ").concat(String.valueOf(weightOfMaterial)));
                        ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT14 total so far for this material: ").concat(String.valueOf(this.ImportInpTot[indexOfMaterial])));
                        if (fate.equalsIgnoreCase("Reuse")) {
                            ProdMaint.logMessageToAuditFile("AUDIT15 This item is of fate: reuse");
                            int n3 = indexOfMaterial;
                            this.ImportInpReuse[n3] = this.ImportInpReuse[n3] + weightOfMaterial;
                        }
                    }
                    if (!fate.equalsIgnoreCase("Reuse") && !fate.equals("Onward Reuse")) {
                        double[] dArray = this.WasteMgtTot[0];
                        int n = indexOfMaterial;
                        dArray[n] = dArray[n] + weightOfMaterial;
                        ProdMaint.logMessageToAuditFile("AUDIT16 This item is neither Reuse nor Onward Reuse");
                        ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT16 Total so far for Waste Mgmt0: ").concat(String.valueOf(this.WasteMgtTot[0][indexOfMaterial])));
                        if (fate.indexOf("Recycled") != -1) {
                            if (fate.equalsIgnoreCase("Recycled (RPS)")) {
                                ProdMaint.logMessageToAuditFile("AUDIT17 recycled rps - so not included in reuse section 1.1");
                                ProdMaint.logMessageToAuditFile("AUDIT17 but included in section 1.3, in total and 1a. ");
                                double[] dArray2 = this.WasteMgtTot[1];
                                int n4 = indexOfMaterial;
                                dArray2[n4] = dArray2[n4] + weightOfMaterial;
                                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT17 Total so far for Waste Mgmt1: ").concat(String.valueOf(this.WasteMgtTot[1][indexOfMaterial])));
                            }
                            if (fate.equalsIgnoreCase("Recycled (Non-RPS)")) {
                                ProdMaint.logMessageToAuditFile("AUDIT18 recycled NON-rps - so not included in reuse section 1.2");
                                ProdMaint.logMessageToAuditFile("AUDIT18 but included in section 1.3, in total and 1a. ");
                                double[] dArray3 = this.WasteMgtTot[2];
                                int n5 = indexOfMaterial;
                                dArray3[n5] = dArray3[n5] + weightOfMaterial;
                                ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT18 Total so far for Waste Mgmt2: ").concat(String.valueOf(this.WasteMgtTot[2][indexOfMaterial])));
                            }
                            double[] dArray4 = this.WasteMgtTot[3];
                            int n6 = indexOfMaterial;
                            dArray4[n6] = dArray4[n6] + weightOfMaterial;
                            ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT18 Total so far for Waste Mgmt3: ").concat(String.valueOf(this.WasteMgtTot[3][indexOfMaterial])));
                        } else if (fate.equalsIgnoreCase("Recovery")) {
                            ProdMaint.logMessageToAuditFile("AUDIT19 recovery");
                            double[] dArray5 = this.WasteMgtTot[4];
                            int n7 = indexOfMaterial;
                            dArray5[n7] = dArray5[n7] + weightOfMaterial;
                        }
                        if (fate.indexOf("Disposal") != -1) {
                            ProdMaint.logMessageToAuditFile("AUDIT20 disposal");
                            double[] dArray6 = this.WasteMgtTot[5];
                            int n8 = indexOfMaterial;
                            dArray6[n8] = dArray6[n8] + weightOfMaterial;
                        }
                    }
                }
                if (inputOutput.equalsIgnoreCase("Output") && !fate.equalsIgnoreCase("Onward Reuse")) {
                    ProdMaint.logMessageToAuditFile("AUDIT21 This is an Output item, not for onward reuse");
                    if (inputItem != null && inputItem.length() > 0) {
                        countryIE = this.isInputItemSourcedInIreland(inputItem);
                    } else if (!fate.equalsIgnoreCase("End-User")) {
                        countryIE = fate.indexOf("IE") == 0;
                    } else {
                        countryIE = false;
                        ProdMaint.logMessageToAuditFile("DEBUG Not Irish-Sourced.");
                    }
                    if (exported.equalsIgnoreCase("Both") || exported.equalsIgnoreCase("No")) {
                        if (countryIE) {
                            ProdMaint.logMessageToAuditFile("AUDIT26 supplied to ROI");
                            double[] dArray = this.IrishOutputROITot[0];
                            int n = indexOfMaterial;
                            dArray[n] = dArray[n] + weightOfMaterial;
                            double[] dArray7 = this.IrishOutputROITot[3];
                            int n9 = indexOfMaterial;
                            dArray7[n9] = dArray7[n9] + weightOfMaterial;
                            double[] dArray8 = this.IrishOutputROITot[4];
                            int n10 = indexOfMaterial;
                            dArray8[n10] = dArray8[n10] + weightOfMaterial;
                            ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT27 weightOfMaterial ").concat(String.valueOf(weightOfMaterial)));
                            if (!packagType.equalsIgnoreCase("Primary")) {
                                double[] dArray9 = this.IrishOutputROITot[5];
                                int n11 = indexOfMaterial;
                                dArray9[n11] = dArray9[n11] + weightOfMaterial;
                            }
                        } else {
                            double[] dArray = this.ImportedOutputROITot[0];
                            int n = indexOfMaterial;
                            dArray[n] = dArray[n] + weightOfMaterial;
                            double[] dArray10 = this.ImportedOutputROITot[3];
                            int n12 = indexOfMaterial;
                            dArray10[n12] = dArray10[n12] + weightOfMaterial;
                            double[] dArray11 = this.ImportedOutputROITot[4];
                            int n13 = indexOfMaterial;
                            dArray11[n13] = dArray11[n13] + weightOfMaterial;
                            ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT30 Imported weightOfMaterial ").concat(String.valueOf(weightOfMaterial)));
                            if (!packagType.equalsIgnoreCase("Primary")) {
                                double[] dArray12 = this.ImportedOutputROITot[5];
                                int n14 = indexOfMaterial;
                                dArray12[n14] = dArray12[n14] + weightOfMaterial;
                            }
                        }
                    }
                    if (material.equalsIgnoreCase("plastic")) {
                        // empty if block
                    }
                    double weightOfMaterialExported = Double.valueOf(weightPerSU) * quantityOfItemExported / (double)1000;
                    ProdMaint.logMessageToAuditFile("Trace should print exported weight here ");
                    if (exported.equalsIgnoreCase("Both") || exported.equalsIgnoreCase("Yes")) {
                        int n = indexOfMaterial;
                        this.Exports[n] = this.Exports[n] + weightOfMaterialExported;
                        ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT33 weight exported: ").concat(String.valueOf(weightOfMaterialExported)));
                        ProdMaint.logMessageToAuditFile(String.valueOf("AUDIT34 total exported for this material so far: ").concat(String.valueOf(this.Exports[indexOfMaterial])));
                    }
                    ProdMaint.logMessageToAuditFile("Trace 1");
                }
                lastItem = Item;
                ProdMaint.logMessageToAuditFile("AUDIT Treat as Output packaging for Onward Reuse.");
            }
            ProdMaint.logMessageToAuditFile("Trace 3");
        }
        catch (Exception exc) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 084: ReportBuilder: loopRecordsetAndFillStorageVariables: ").concat(String.valueOf(exc)));
        }
    }

    private double getQuantityOfItem(String item, String inputOutput, boolean export) {
        String thisItem = "";
        String lastItem = "";
        double num = -1.0;
        boolean found = false;
        try {
            try {
                for (int i = 0; i < this.parsedInputData.length && !found; ++i) {
                    String s;
                    String[] thisItemsRow = this.parsedInputData[i];
                    if (thisItemsRow == null || thisItemsRow.length <= 0 || thisItemsRow[0] == null) continue;
                    thisItem = thisItemsRow[0];
                    if (item.equals(thisItem) && item.equals(lastItem) && export) {
                        s = thisItemsRow[1];
                        num = Double.valueOf(s);
                        found = true;
                    } else if (item.equals(thisItem) && !export) {
                        s = thisItemsRow[1];
                        num = Double.valueOf(s);
                        found = true;
                    }
                    lastItem = thisItem;
                }
                Object var13_12 = null;
                return num;
            }
            catch (Exception exc) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 085: ReportBuilder: getQuantityOfItem: ").concat(String.valueOf(exc)));
                Object var13_13 = null;
                return num;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            return num;
        }
    }

    private boolean isInputItemSourcedInIreland(String inputItem) {
        boolean OK = false;
        String country = "";
        try {
            try {
                TableModel tableModel = this.parentFrame.ItemsTable.getModel();
                for (int i = 0; i < tableModel.getRowCount() && !OK; ++i) {
                    if (!tableModel.getValueAt(i, 0).toString().equalsIgnoreCase(inputItem) || (country = tableModel.getValueAt(i, 4).toString()).indexOf("IE") == -1) continue;
                    OK = true;
                }
                Object var7_7 = null;
                return OK;
            }
            catch (Exception exc) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 086: ReportBuilder: isInputItemSourcedInIreland: ").concat(String.valueOf(exc)));
                Object var7_8 = null;
                return OK;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            return OK;
        }
    }

    private Vector writeReportToVector() {
        Vector<String[]> retVector = new Vector<String[]>();
        Vector thisLine = new Vector();
        try {
            try {
                retVector.addElement(this.getBlankLine());
                retVector.addElement(this.getBlankLine());
                this.fillReportSection(retVector, "1.1 Irish Sourced Input Packaging", true, "Total Tonnes (including reuse packaging)", this.IrishInpTot, true);
                this.fillReportSection(retVector, null, true, "Reuse Packaging Suitable for Continued Reuse", this.IrishInpReuse, true);
                this.fillReportSection(retVector, "1.2 Imported Input Packaging", true, "Total Tonnes (including reuse packaging)", this.ImportInpTot, true);
                this.fillReportSection(retVector, null, true, "Reuse Packaging Suitable for Continued Reuse", this.ImportInpReuse, true);
                this.fillReportSection(retVector, "1.3 Internal Packaging Waste Management", true, "Total Tonnes (all packaging waste arisings)", this.WasteMgtTot[0], false);
                this.fillReportSection(retVector, null, false, "1a. RPS", this.WasteMgtTot[1], false);
                this.fillReportSection(retVector, null, false, "1b. Non-RPS", this.WasteMgtTot[2], false);
                this.fillReportSection(retVector, null, false, "1. Tonnes for Recycling", this.WasteMgtTot[3], false);
                this.fillReportSection(retVector, null, false, "2. Tonnes for Recovery", this.WasteMgtTot[4], false);
                this.fillReportSection(retVector, null, false, "3. Tonnes for Disposal", this.WasteMgtTot[5], true);
                String[] sThisLine = this.getBlankLine();
                retVector.addElement(sThisLine);
                this.fillReportSection(retVector, "2.1 Irish Sourced Output Packaging - Supplied in ROI", true, "Total Tonnes (including reuse packaging)", this.IrishOutputROITot[0], false);
                this.fillReportSection(retVector, null, false, "Materials Manufacturer", this.IrishOutputROITot[1], false);
                this.fillReportSection(retVector, null, false, "Convertor", this.IrishOutputROITot[2], false);
                this.fillReportSection(retVector, null, false, "Brandholder/Importer", this.IrishOutputROITot[3], false);
                this.fillReportSection(retVector, null, false, "Distributor", this.IrishOutputROITot[4], false);
                this.fillReportSection(retVector, null, false, "Retailer", this.IrishOutputROITot[5], true);
                sThisLine = this.getBlankLine();
                retVector.addElement(sThisLine);
                this.fillReportSection(retVector, "Reuse packaging suitable for continued reuse", true, "Brandholder/Importer", this.IrishOutputROIContReuse[0], false);
                this.fillReportSection(retVector, null, false, "Distributor", this.IrishOutputROIContReuse[1], false);
                this.fillReportSection(retVector, null, false, "Retailer", this.IrishOutputROIContReuse[2], true);
                sThisLine = this.getBlankLine();
                retVector.addElement(sThisLine);
                this.fillReportSection(retVector, "2.3 Imported Output Packaging - Supplied in ROI", true, "Retailer", this.ImportedOutputROITot[0], false);
                this.fillReportSection(retVector, null, false, "Materials Manufacturer", this.ImportedOutputROITot[1], false);
                this.fillReportSection(retVector, null, false, "Convertor", this.ImportedOutputROITot[2], false);
                this.fillReportSection(retVector, null, false, "Brandholder/Importer", this.ImportedOutputROITot[3], false);
                this.fillReportSection(retVector, null, false, "Distributor", this.ImportedOutputROITot[4], false);
                this.fillReportSection(retVector, null, false, "Retailer", this.ImportedOutputROITot[5], true);
                sThisLine = this.getBlankLine();
                retVector.addElement(sThisLine);
                this.fillReportSection(retVector, "Reuse packaging suitable for continued reuse", false, "Brandholder/Importer", this.ImportedOutputROIContReuse[0], false);
                this.fillReportSection(retVector, null, false, "Distributor", this.ImportedOutputROIContReuse[1], false);
                this.fillReportSection(retVector, null, false, "Retailer", this.ImportedOutputROIContReuse[2], false);
                sThisLine = this.getBlankLine();
                retVector.addElement(sThisLine);
                this.fillReportSection(retVector, "2.2 + 2.4 All Exports", true, "Empty Packaging (including reuse packaging)", null, false);
                this.fillReportSection(retVector, null, false, "Filled Packaging", this.Exports, true);
            }
            catch (Exception exc) {
                ProdMaint.logMessageToFile(String.valueOf("ERROR 087: ReportBuilder: writeReportToVector: ").concat(String.valueOf(exc)));
                Object var6_5 = null;
                return retVector;
            }
            Object var6_4 = null;
            return retVector;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            return retVector;
        }
    }

    private String[] getBlankLine() {
        String[] line = new String[13];
        for (int i = 0; i < 13; ++i) {
            line[i] = "";
        }
        return line;
    }

    private String[] fillMaterialsLine() {
        String[] line = this.getBlankLine();
        for (int i = 0; i < PackagDialog.materialDD.length; ++i) {
            line[i + 2] = PackagDialog.materialDD[i];
        }
        return line;
    }

    private String[] fillLineWithDoubleArray(String[] sThisLine, double[] dblArray) {
        for (int i = 0; i < PackagDialog.materialDD.length; ++i) {
            sThisLine[i + 3] = new Double(dblArray[i]).toString();
        }
        return sThisLine;
    }

    private void writeReport(Vector reportVector) {
        Vector<String> lines = new Vector<String>();
        try {
            Enumeration enumeration = reportVector.elements();
            while (enumeration.hasMoreElements()) {
                String[] s_thisRow = (String[])enumeration.nextElement();
                String thisLineOfReport = this.UtilityObject.makeTildaString(s_thisRow).trim();
                lines.addElement(thisLineOfReport);
                ProdMaint.logMessageToAuditFile(thisLineOfReport);
            }
            String[] linesArray = this.UtilityObject.getStringsFromVector(lines);
            String[] cmdo = new String[linesArray.length + 2];
            cmdo[0] = "wscript";
            cmdo[1] = ".\\files\\js\\newItemsReport.js";
            for (int i = 2; i < cmdo.length; ++i) {
                cmdo[i] = linesArray[i - 2];
            }
            Runtime.getRuntime().exec(cmdo);
        }
        catch (Exception exc) {
            ProdMaint.logMessageToFile(String.valueOf("ERROR 088: ReportBuilder: writeReport error ").concat(String.valueOf(exc)));
        }
    }

    private void fillReportSection(Vector reportVector, String title, boolean blueLine, String lineHeader, double[] values, boolean trailingLine) {
        try {
            String[] sThisLine;
            if (title != null) {
                sThisLine = this.getBlankLine();
                sThisLine[0] = title;
                reportVector.addElement(sThisLine);
                if (blueLine) {
                    sThisLine[1] = "B";
                }
            }
            sThisLine = this.getBlankLine();
            sThisLine[0] = lineHeader;
            if (values != null) {
                this.fillLineWithDoubleArray(sThisLine, values);
            }
            reportVector.addElement(sThisLine);
            if (trailingLine) {
                reportVector.addElement(this.getBlankLine());
            }
        }
        catch (Exception exc) {
            ProdMaint.logMessageToFile(String.valueOf(String.valueOf(String.valueOf("ERROR 089: ReportBuilder: fillReportSection: ").concat(String.valueOf(exc))).concat(String.valueOf(", lineHeader="))).concat(String.valueOf(lineHeader)));
        }
    }
}

